#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <allegro.h>
#include "leanview.h"
#define ACTLANDW 64
#define ACTLANDH 32
#define MASKSIZE 0x1000

int s,actland_num;
char **land;
char **actland;
MAP *map;
int cache_x,cache_y;
extern int SHOW_OBJ;
extern int screen_x,screen_y;
extern OBJ_BUF obj_buf[OBJCACHESIZE];
extern volatile short active_land_count;
extern short active_obj_flush;
extern char sprite_nomoved[SPRITEBUFSIZE];

/* ر Cache ṹ */
typedef struct {
        short block;   //ͼı
        BITMAP *land;  //رλͼ (256 ɫ)
        char *mask;
        RGB *pal;  //λͼʹõĵɫָ
        } CACHE;

typedef struct {
        short frames;
        BITMAP **bmp;
        } ACTLANDBMP;


CACHE cache[9];        //ر Cache
PALETTE cache_pal[9];  //ɫ Cache
ACTLANDBMP *actlandbmp;

extern BITMAP *buf;    //Ļ˫ (9/4 Ļ)
extern BITMAP *act_buf;
extern BITMAP *buf_mask;

typedef struct {
       short x1;
       short y;
       short x2;
       } maskline;


/* ʼر */

void land_exit()
{
 int i,j;
 for (i=0;i<9;i++) {
    destroy_bitmap(cache[i].land);
    free(cache[i].mask);
    }
 for (i=0;i<s;i++) {
    free(land[i]);
    free(actland[i]);
    }
 free(land);
 free(actland);
 free(map);
 for (i=0;i<actland_num;i++) {
    for (j=0;j<actlandbmp[i].frames;j++)
       destroy_bitmap(actlandbmp[i].bmp[j]);
    free(actlandbmp[i].bmp);
    }
 free(actlandbmp);
}

void load_mask(int i)
{
    FILE *f;
    if (get_filename(actland[cache[i].block])[1]==0) *cache[i].mask=0;
    else {
         f=fopen(actland[cache[i].block],"rb");
         fread(cache[i].mask,MASKSIZE,1,f);
         fclose(f);
         }
}


void land_init(int *w,int *h)
{
 int i,j,n;
// BITMAP *temp;
 FILE *f;
 PALETTE pal;
 char path[20];
 set_color_depth(8);
 f=fopen("land.dat","r");
 fscanf(f,"%d,%d\n",w,h);
 s=(*w)*(*h);
 map=(MAP *)malloc(s*sizeof(MAP));
 land=(char **)malloc(s*sizeof(char*));
 for (i=0;i<s;i++)
    land[i]=(char *)malloc(40);
 fgets(path,20,f);
 for (i=0;i<s;i++) {
    strcpy(land[i],path);
    fgets(strchr(land[i],'\n'),40,f);
    *strchr(land[i],'\n')=0;
    }
 actland=(char **)malloc(s*sizeof(char*));
 for (i=0;i<s;i++)
    actland[i]=(char *)malloc(40);
 for (i=0;i<s;i++) {
    strcpy(actland[i],path);
    fgets(strchr(actland[i],'\n'),40,f);
    *strchr(actland[i],'\n')=0;
    }
 for (i=0;i<(*h);i++)
    for (j=0;j<*w;j++) {
       map[i*(*w)+j].block[0]=(i-1<0)?-1:(i-1)*(*w)+j;
       map[i*(*w)+j].block[1]=(i+1>(*h))?-1:(i+1)*(*w)+j;
       map[i*(*w)+j].block[2]=(j-1<0)?-1:i*(*w)+j-1;
       map[i*(*w)+j].block[3]=(j+1>(*w))?-1:i*(*w)+j+1;
       }
 n=cache[0].block=0;
 n=cache[1].block=map[n].block[3];
 n=cache[2].block=map[n].block[3];
 n=cache[5].block=map[n].block[1];
 n=cache[4].block=map[n].block[2];
 n=cache[3].block=map[n].block[2];
 n=cache[6].block=map[n].block[1];
 n=cache[7].block=map[n].block[3];
 cache[8].block=map[n].block[3];
 for (i=0;i<9;i++) {
    FILE *f;
    cache[i].pal=cache_pal[i];
    cache[i].mask=(char *)malloc(MASKSIZE);
    load_mask(i);
    cache[i].land=load_bitmap(land[cache[i].block],cache[i].pal);
    }
 fclose(f);
 set_color_depth(COLORDEPTH);
 f=fopen("actland.dat","r");
 fscanf(f,"%d\n",&actland_num);
 actlandbmp=(ACTLANDBMP *)malloc(actland_num*sizeof(ACTLANDBMP));
 fgets(path,20,f);
 for (i=0;i<actland_num;i++) {
    fscanf(f,"%d\n",&actlandbmp[i].frames);
    actlandbmp[i].bmp=(BITMAP **)malloc(actlandbmp[i].frames*sizeof(BITMAP *));
    for (j=0;j<actlandbmp[i].frames;j++) {
       char filename[80];
        strcpy(filename,path);
        fgets(strchr(filename,'\n'),40,f);
        *strchr(filename,'\n')=0;
        actlandbmp[i].bmp[j]=load_bitmap(filename,pal);
        }
       }
}

void actland_flush()
{
 static actland_frame[256];
 int i,j,winx,winy;
 char *c;
 maskline *t;

 active_land_count=0;
 // CACHE 0
 winy=cache_y-screen_y;
 for (winx=i=0;i<3;i++,winx+=BLOCKW) {
     for (c=cache[i].mask;*c;c=(char *)(++t)) {
         drawing_mode(DRAW_MODE_COPY_PATTERN,actlandbmp[*c-1].bmp[actland_frame[*c-1]],0,0);
         t=(maskline *)(c+1);
         while(winy+t->y<0 && t->y>=0) ++t;
         for (;t->x1>=0;++t) {
             hline(buf,t->x1+winx,t->y,t->x2+winx,0);
             hline(act_buf,t->x1+winx,t->y,t->x2+winx,0);
             }
         }
     }
 for (winx=0;i<6;i++,winx+=BLOCKW) {
     for (c=cache[i].mask;*c;c=(char *)(++t)) {
         drawing_mode(DRAW_MODE_COPY_PATTERN,actlandbmp[*c-1].bmp[actland_frame[*c-1]],0,0);
         t=(maskline *)(c+1);
         for (;t->x1>=0;++t) {
             hline(buf,t->x1+winx,t->y+BLOCKH,t->x2+winx,0);
             hline(act_buf,t->x1+winx,t->y+BLOCKH,t->x2+winx,0);
             }
         }
     }
 winy+=2*BLOCKH;
 for (winx=0;i<9;i++,winx+=BLOCKW) {
     for (c=cache[i].mask;*c;c=(char *)(++t)) {
         drawing_mode(DRAW_MODE_COPY_PATTERN,actlandbmp[*c-1].bmp[actland_frame[*c-1]],0,0);
         t=(maskline *)(c+1);
         if (winy+t->y>SCREENH) break;
         for (;t->x1>=0;++t) {
             hline(buf,t->x1+winx,t->y+2*BLOCKH,t->x2+winx,0);
             hline(act_buf,t->x1+winx,t->y+2*BLOCKH,t->x2+winx,0);
             }
         }
     }

 for (i=0;i<256;i++)
     if (++actland_frame[i]>=actlandbmp[i].frames) actland_frame[i]=0;
 solid_mode();
}

/**********************************
   õرˢĻ˫
   ر Cache  9 ر
       0 1 2
       3 4 5
       6 7 8
   ĻС 4 ,СΪ 9 
***********************************/

void land_buf_flush()
{
 CACHE *c=&cache[0];
 set_palette(c->pal);
 blit(c->land,buf,0,0,0,0,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,BLOCKW,0,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,SCREENW,0,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,0,BLOCKH,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,BLOCKW,BLOCKH,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,SCREENW,BLOCKH,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,0,SCREENH,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,BLOCKW,SCREENH,BLOCKW,BLOCKH);
 c++;
 set_palette(c->pal);
 blit(c->land,buf,0,0,SCREENW,SCREENH,BLOCKW,BLOCKH);
}

/***************************************
    жϵǰҪĵرǷڴ,
    ,.˺
    8  Cache ʧЧ
***************************************/

void land_cache_flush()
{
/* winx, winy ΪĻĺмĵرϽƫ
 * ֵ (0,0)-(BLOCKW,BLOCKH) ʱ,رݶ Cache 
 */
 char *m;
 int winx=screen_x-cache_x,winy=screen_y-cache_y,i=0;
 if (winx>=0 && winx<=BLOCKW && winy>=0 && winy<=BLOCKH) return;
 set_color_depth(8);
 if (winx<0) {
   if (winy<0) {
/* ĻĴӿ 4 תƵ 0 ()
 *          |0  1| 2
 *          |3 <4| 5>
 *           6 <7  8>
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[2].land);
   destroy_bitmap(cache[5].land);
   destroy_bitmap(cache[8].land);
   destroy_bitmap(cache[6].land);
   destroy_bitmap(cache[7].land);

   c=&cache[8],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1=cache;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[5],c1=&cache[1];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[7],c1=&cache[3];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[1].land=load_bitmap(land[cache[1].block=map[cache[4].block].block[0]],cache[1].pal);
   cache[2].land=load_bitmap(land[cache[2].block=map[cache[5].block].block[0]],cache[2].pal);
   cache[0].land=load_bitmap(land[cache[0].block=map[cache[1].block].block[2]],cache[0].pal);
   cache[3].land=load_bitmap(land[cache[3].block=map[cache[4].block].block[2]],cache[3].pal);
   cache[6].land=load_bitmap(land[cache[6].block=map[cache[7].block].block[2]],cache[6].pal);
   load_mask(1);
   load_mask(2);
   load_mask(0);
   load_mask(3);
   load_mask(6);

   cache_x-=BLOCKW;
   cache_y-=BLOCKH;
     }
   else if (winy>BLOCKH) {
/* ĻĴӿ 4 תƵ 6 ()
 *           0 <1  2>
 *          |3 <4| 5>
 *          |6  7| 8
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[2].land);
   destroy_bitmap(cache[5].land);
   destroy_bitmap(cache[8].land);
   destroy_bitmap(cache[0].land);
   destroy_bitmap(cache[1].land);

   c=&cache[2],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1+=2;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[1],c1=&cache[3];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[5],c1=&cache[7];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[7].land=load_bitmap(land[cache[7].block=map[cache[4].block].block[1]],cache[7].pal);
   cache[8].land=load_bitmap(land[cache[8].block=map[cache[5].block].block[1]],cache[8].pal);
   cache[0].land=load_bitmap(land[cache[0].block=map[cache[1].block].block[2]],cache[0].pal);
   cache[3].land=load_bitmap(land[cache[3].block=map[cache[4].block].block[2]],cache[3].pal);
   cache[6].land=load_bitmap(land[cache[6].block=map[cache[7].block].block[2]],cache[6].pal);
   load_mask(7);
   load_mask(8);
   load_mask(0);
   load_mask(3);
   load_mask(6);

   cache_x-=BLOCKW;
   cache_y+=BLOCKH;
     }
 else {
/* ĻĴӿ 4 תƵ 3 ()
 *          |0 <1| 2>
 *          |3 <4| 5>
 *          |6 <7| 8>
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[2].land);
   destroy_bitmap(cache[5].land);
   destroy_bitmap(cache[8].land);

   c1=(c=&cache[8])-1;
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c,--c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c;
   c->pal=p;
   c1->mask=m;
   --c,c1-=2;

   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c,--c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c;
   c->pal=p;
   c1->mask=m;
   --c,c1-=2;

   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c,--c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   --c;
   c->pal=p;
   c1->mask=m;

   cache[0].land=load_bitmap(land[cache[0].block=map[cache[1].block].block[2]],cache[0].pal);
   cache[3].land=load_bitmap(land[cache[3].block=map[cache[4].block].block[2]],cache[3].pal);
   cache[6].land=load_bitmap(land[cache[6].block=map[cache[7].block].block[2]],cache[6].pal);
   load_mask(0);
   load_mask(3);
   load_mask(6);

   cache_x-=BLOCKW;
   }
 }
 else if (winx>BLOCKW) {
   if (winy<0) {
/* ĻĴӿ 4 תƵ 2 ()
 *           0 |1  2|
 *          <3 |4> 5|
 *          <6  7> 8
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[0].land);
   destroy_bitmap(cache[3].land);
   destroy_bitmap(cache[8].land);
   destroy_bitmap(cache[6].land);
   destroy_bitmap(cache[7].land);

   c=&cache[6],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1-=2;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[7],c1=&cache[5];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[3],c1=&cache[1];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[0].land=load_bitmap(land[cache[0].block=map[cache[3].block].block[0]],cache[0].pal);
   cache[1].land=load_bitmap(land[cache[1].block=map[cache[4].block].block[0]],cache[1].pal);
   cache[2].land=load_bitmap(land[cache[2].block=map[cache[1].block].block[3]],cache[2].pal);
   cache[5].land=load_bitmap(land[cache[5].block=map[cache[4].block].block[3]],cache[5].pal);
   cache[8].land=load_bitmap(land[cache[8].block=map[cache[7].block].block[3]],cache[8].pal);
   load_mask(0);
   load_mask(1);
   load_mask(2);
   load_mask(5);
   load_mask(8);

   cache_x+=BLOCKW;
   cache_y-=BLOCKH;
     }
   else if (winy>BLOCKH) {
/* ĻĴӿ 4 תƵ 8 ()
 *          <0  1> 2
 *          <3 |4> 5|
 *           6 |7  8|
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[0].land);
   destroy_bitmap(cache[3].land);
   destroy_bitmap(cache[1].land);
   destroy_bitmap(cache[6].land);
   destroy_bitmap(cache[2].land);

   c=&cache[0],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1+=4;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[1],c1=&cache[5];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[3],c1=&cache[7];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[2].land=load_bitmap(land[cache[2].block=map[cache[1].block].block[3]],cache[2].pal);
   cache[5].land=load_bitmap(land[cache[5].block=map[cache[4].block].block[3]],cache[5].pal);
   cache[6].land=load_bitmap(land[cache[6].block=map[cache[3].block].block[1]],cache[6].pal);
   cache[7].land=load_bitmap(land[cache[7].block=map[cache[4].block].block[1]],cache[7].pal);
   cache[8].land=load_bitmap(land[cache[8].block=map[cache[5].block].block[1]],cache[8].pal);
   load_mask(2);
   load_mask(5);
   load_mask(6);
   load_mask(7);
   load_mask(8);

   cache_x+=BLOCKW;
   cache_y+=BLOCKH;
     }
   else {
/* ĻĴӿ 4 תƵ 5 ()
 *          <0 |1> 2|
 *          <3 |4> 5|
 *          <6 |7> 8|
 */
   RGB *p;
   CACHE *c,*c1;
   destroy_bitmap(cache[0].land);
   destroy_bitmap(cache[3].land);
   destroy_bitmap(cache[6].land);

   c1=(c=cache)+1;
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c,++c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c;
   c->pal=p;
   c1->mask=m;
   ++c,c1+=2;

   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c,++c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c;
   c->pal=p;
   c1->mask=m;
   ++c,c1+=2;

   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c,++c1;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   ++c;
   c->pal=p;
   c1->mask=m;

   cache[2].land=load_bitmap(land[cache[2].block=map[cache[1].block].block[3]],cache[2].pal);
   cache[5].land=load_bitmap(land[cache[5].block=map[cache[4].block].block[3]],cache[5].pal);
   cache[8].land=load_bitmap(land[cache[8].block=map[cache[7].block].block[3]],cache[8].pal);
   load_mask(2);
   load_mask(5);
   load_mask(8);

   cache_x+=BLOCKW;
   }
 }
 else if (winy<0) {
/* ĻĴӿ 4 תƵ 7 ()
 *         < 0  1  2 >
 *         <|3  4  5|>
 *          |6  7  8|
 */
   CACHE *c,*c1;
   RGB *p;
   destroy_bitmap(cache[6].land);
   destroy_bitmap(cache[7].land);
   destroy_bitmap(cache[8].land);

   c=&cache[6],c1=&cache[3];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1-=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[7],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1-=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[8],c1=&cache[5];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1-=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[0].land=load_bitmap(land[cache[0].block=map[cache[3].block].block[0]],cache[0].pal);
   cache[1].land=load_bitmap(land[cache[1].block=map[cache[4].block].block[0]],cache[1].pal);
   cache[2].land=load_bitmap(land[cache[2].block=map[cache[5].block].block[0]],cache[2].pal);
   load_mask(0);
   load_mask(1);
   load_mask(2);

   cache_y-=BLOCKH;
   }
 else if (winy>BLOCKH) {
/* ĻĴӿ 4 תƵ 1 ()
 *          |0  1  2|
 *         <|3  4  5|>
 *         < 6  7  8 >
 */
   CACHE *c,*c1;
   RGB *p;
   destroy_bitmap(cache[0].land);
   destroy_bitmap(cache[1].land);
   destroy_bitmap(cache[2].land);

   c=&cache[0],c1=&cache[3];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1+=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[1],c1=&cache[4];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1+=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   c=&cache[2],c1=&cache[5];
   m=c->mask;
   p=c->pal;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c=c1,c1+=3;
   c->block=c1->block;
   c->land=c1->land;
   c->mask=c1->mask;
   c->pal=c1->pal;
   c1->pal=p;
   c1->mask=m;

   cache[6].land=load_bitmap(land[cache[6].block=map[cache[3].block].block[1]],cache[6].pal);
   cache[7].land=load_bitmap(land[cache[7].block=map[cache[4].block].block[1]],cache[7].pal);
   cache[8].land=load_bitmap(land[cache[8].block=map[cache[5].block].block[1]],cache[8].pal);
   load_mask(6);
   load_mask(7);
   load_mask(8);

   cache_y+=BLOCKH;
   }
 set_color_depth(COLORDEPTH);
 land_buf_flush();
 actland_flush();
 obj_buf_sort(cache[0].block,cache[3].block,cache[6].block);
 bzero(sprite_nomoved,SPRITEBUFSIZE);

 for (i=0;obj_buf[i].sprite;i++)
    if (SHOW_OBJ && obj_buf[i].frames==1) draw_object(i);
 blit(buf,act_buf,0,0,0,0,SCREENW+BLOCKW,SCREENH+BLOCKH);
 active_obj_flush=1;
 for (i=0;obj_buf[i].sprite;i++)
    draw_active_object(i);
}
