#ifndef LEANVIEW_H
#define LEANVIEW_H

#define BLOCKW 320
#define BLOCKH 240
#define SCREENW 640
#define SCREENH 480

#define STAND 0
#define WALK 1
#define WALKSTART 2
#define WALKSTOP 3
#define ANIMAX 12
#define MAXFRAMES 16
#define MAXSPRITES 64
#define BACKALPHA 224
#define STEPLEN 3

#define SPRITECACHESIZE 16
#define SPRITEBUFSIZE 32
#define OBJCACHESIZE 1024
#define COLORDEPTH 16
#define MASK_COLOR 0xF81F
#define ACTLANDSPEED 5
/*
MASK_COLOR_15      0x7C1F
MASK_COLOR_16      0xF81F
MASK_COLOR_24      0xFF00FF
MASK_COLOR_32      0xFF00FF
*/

#define MAXINT 0x7fffffff
#define DIS 8

#define SPRITEMAXSIZE 256
#define MAXSTEP 256


/* ͼṹ, ÿСΪ 1/4 Ļ */
typedef struct {
        short block[4];  //ҵĵͼ
        } MAP;

typedef struct {
        int x;
        int y;
        int pos;
        int alpha;
        BITMAP *sprite;
        BITMAP *mask;
        RGB *pal;
        unsigned char frames,frame,timer_id,onactland;
        BITMAP **sprites;
        } OBJ_BUF;


typedef struct {
        int id;
        int freq;
        PALETTE pal;
        unsigned char ani,frames[ANIMAX];
        BITMAP *sprites[DIS][ANIMAX][MAXFRAMES];
        BITMAP *mask[DIS][ANIMAX];
        } SPRITE_CACHE;

typedef struct {
        unsigned char alpha,frame,timer_id,stat,pathlen,step;
        int pathx[MAXSTEP],pathy[MAXSTEP];
        unsigned char dis[MAXSTEP];
        BITMAP *buf;
        SPRITE_CACHE *images;
        } SPRITE_BUF;

void land_init(int *,int *);
void land_exit();
void land_buf_flush();
void actland_flush();
void land_cache_flush();

void obj_init();
void obj_exit();
void obj_buf_sort(int line1,int line2,int line3);
__inline__ void draw_object(int i);


int sprite_load(int id,int x,int y,int alpha,int dis,int speed);
void draw_sp(int i);


#endif          /* ifndef LEANVIEW_H */

