#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "leanview.h"

#define MAXINT 0x7fffffff
/* ֳ,̬ĺͶ̬,̬嵱ȻΪ鴦,
   ǿԭ˶,Եٶȵ.
    Engine ,Բͬ嶼бŵ, 100000
   ϵ,Ƕ̬
*/
#define ACTOBJ 100000
#define ACTOBJ_ONACTLAND 200000

/* ݽṹʹĿ,̬һ֡*/
#define MAXFRAMES 16
/* ͬһ,(9/4Ļ), ö̬,
   䲻ͬ˶ٶ
*/
#define MAXACTOBJ 32

/* ڴر */
extern BITMAP *buf,*act_buf;

/* obj_num ̬, active_obj_num ̬ */
int obj_num,active_obj_num;

/* ̬λͼļ,ʵʱ, */
char **obj;
/* ̬ĵͼļ, ʵ, ʹԼ 2 ɫʽ,
   ʹõ 256 ɫͼʽ
*/
char **obj_mask;

/* ̬ĸ֡λͼļ,ʵʱ,ʹ */
char ***active_obj;
/* ̬ĵͼļ,ڻڿ,һͼ? */
char **active_obj_mask;

/* ÿ̬֡ */
unsigned char *active_obj_frames;

short buf_obj_num;

/* رCacheĻмǿϽ */
extern int cache_x,screen_x;
extern int cache_y,screen_y;
extern short active_obj_flush;

typedef struct {
        int x;                    // Ϸе x
        int y;                    // Ϸе y
        int id;                   // ı,ͬλͼͬ
        int pos;                  // ǰϵı,λòͬ,Ųͬ
        unsigned char alpha;      // Alpha ֵ(0~255) 255 Ϊ͸
        unsigned char frames;     // ̬Ϊ 1, ̬Ϊ֡
        unsigned char speed;      // ̬˶ٶ, ̬Ϊ 0
        unsigned char onactland;
        } OBJ;                    // ˽ṹеͼϵ

typedef struct {
        int id;                   // CACHE ı
        int freq;                 // һʹʱڵϢ
        unsigned char frames;     // Ƕ̬,Ϊ֡
        BITMAP *sprite;           // ̬λͼ,̬Ϊر
        BITMAP *mask;             // ͼ
        PALETTE pal;              // ɫ
        BITMAP *sprites[MAXFRAMES];  // ̬رĸ֡,һ buffer 
        } OBJ_CACHE;              // ˽ṹ Cache

short *object_num;                // ÿرϵ
OBJ_CACHE obj_cache[OBJCACHESIZE]; //  CACHE
OBJ **object;                     // Ϣ
OBJ_BUF obj_buf[OBJCACHESIZE];

int maps;                         // ر

int obj_cache_load(int id);       // λͼ CACHE
volatile short active_obj_count[MAXACTOBJ]; // ̬嵱ǰ֡
short active_obj_speed[MAXACTOBJ];  // ̬ٶ
volatile short active_land_count;

void active_obj_timer()           // Ƹ̬˶ʱӺ
{
 int i;
 for (i=0;active_obj_speed[i] && i<MAXACTOBJ;i++)
    active_obj_count[i]+=active_obj_speed[i];
 active_land_count++;
}

END_OF_FUNCTION(active_obj_timer);

void obj_init()   // 岿ֵĳʼ, Engine Ϊʱṹļд
{
 int i,j;
 FILE *f;
 char path[20];

 f=fopen("obj.dat","r");
 fscanf(f,"%d,%d\n",&obj_num,&active_obj_num);
 obj=(char **)malloc(obj_num*sizeof(char*));
 obj_mask=(char **)malloc(obj_num*sizeof(char*));
 for (i=0;i<obj_num;i++) {
    obj[i]=(char *)malloc(40);
    obj_mask[i]=(char *)malloc(40);
    }
 fgets(path,20,f);
 for (i=0;i<obj_num;i++) {
    strcpy(obj[i],path);
    fgets(strchr(obj[i],'\n'),40,f);
    *strchr(obj[i],'\n')=0;
    strcpy(obj_mask[i],path);
    fgets(strchr(obj_mask[i],'\n'),40,f);
    *strchr(obj_mask[i],'\n')=0;
    }
 active_obj=(char ***)malloc(active_obj_num*sizeof(char**));
 active_obj_mask=(char **)malloc(active_obj_num*sizeof(char*));
 active_obj_frames=(unsigned char *)malloc(active_obj_num*sizeof(unsigned char));
 for (i=0;i<active_obj_num;i++) {
    fscanf(f,"%d\n",&active_obj_frames[i]);
    active_obj[i]=(char **)malloc(active_obj_frames[i]*sizeof(char*));
    for (j=0;j<active_obj_frames[i];j++) {
       active_obj[i][j]=(char *)malloc(40);
       strcpy(active_obj[i][j],path);
       fgets(strchr(active_obj[i][j],'\n'),40,f);
       *strchr(active_obj[i][j],'\n')=0;
       }
    active_obj_mask[i]=(char *)malloc(40);
    strcpy(active_obj_mask[i],path);
    fgets(strchr(active_obj_mask[i],'\n'),40,f);
    *strchr(active_obj_mask[i],'\n')=0;
    }
 for (i=0;i<OBJCACHESIZE;i++)
    obj_cache[i].id=obj_cache[i].freq=-1;
 fclose(f);
 f=fopen("map.dat","r");
 fscanf(f,"%d\n",&maps);
 object=(OBJ **)malloc(maps*sizeof(OBJ *));
 object_num=(short *)malloc(maps*sizeof(short));

 for (i=0;i<maps;i++) {
    fscanf(f,"%d\n",&object_num[i]);
    if (object_num[i]==0) continue;
    object[i]=(OBJ *)malloc(object_num[i]*sizeof(OBJ));
    for (j=0;j<object_num[i];j++) {
       fscanf(f,"%d,%d,%d,%d,%d,%d\n",&object[i][j].x,&object[i][j].y,&object[i][j].id,&object[i][j].pos,&object[i][j].alpha,&object[i][j].speed);
       if (object[i][j].id<ACTOBJ)
         object[i][j].frames=1;
       else if (object[i][j].id<ACTOBJ_ONACTLAND)
         object[i][j].frames=active_obj_frames[object[i][j].id-ACTOBJ],
         object[i][j].onactland=0;
       else object[i][j].frames=active_obj_frames[object[i][j].id-ACTOBJ_ONACTLAND],
         object[i][j].onactland=1,
         object[i][j].id-=(ACTOBJ_ONACTLAND-ACTOBJ);
       }
 }
 fclose(f);
 obj_buf[0].sprite=NULL;
 LOCK_DATA((void *)active_obj_count,i*sizeof(active_obj_count[0]));
 LOCK_DATA((void *)active_obj_speed,i*sizeof(active_obj_speed[0]));
 LOCK_VARIABLE(active_land_count);
 LOCK_FUNCTION(active_obj_timer);
 install_int_ex(active_obj_timer,  BPS_TO_TIMER(20));
 active_obj_speed[0]=0;
}

/* ͷŵ岿ĵڴ */
void obj_exit()
{
 int i,j;
 for (i=0;i<OBJCACHESIZE;i++)
    if (obj_cache[i].id>=0) {
      destroy_bitmap(obj_cache[i].sprite);
      destroy_bitmap(obj_cache[i].mask);
      }
 for (i=0;i<maps;i++)
    free(object[i]);
 for (i=0;i<obj_num;i++) {
    free(obj[i]);
    free(obj_mask);
    }
 free(obj);
 for (i=0;i<active_obj_num;i++) {
    free(active_obj_mask);
    for (j=0;j<active_obj_frames[i];j++)
       free(active_obj[i][j]);
    free(active_obj[i]);
    }
 free(active_obj);
 free(active_obj_frames);
 free(object);
 free(object_num);
}


/*  id Ƿڴ,, CACHE е
   ,, CACHE 
    CACHE , freq ֵ,ûзʵ
*/
int obj_cache_load(int id)
{
 static int freq=0;
 int i,use,minfreq=MAXINT;
 for (i=0;i<OBJCACHESIZE;i++) {
    if (obj_cache[i].id==id) {
      use=i;
      break;
      }
    if (obj_cache[i].freq<minfreq) minfreq=obj_cache[i].freq,use=i;
    }
/*  CACHE ûʱ */
 if (obj_cache[use].id==-1) {
   set_color_depth(8);
   obj_cache[use].id=id;
   obj_cache[use].freq=freq++;
/* Ƕ̬,Ҫ֡λͼ */
   if (id>=ACTOBJ) {
      id-=ACTOBJ;
      obj_cache[use].frames=active_obj_frames[id];
      obj_cache[use].mask=load_bitmap(active_obj_mask[id],obj_cache[use].pal);
      for (i=0;i<active_obj_frames[id];i++)
          obj_cache[use].sprites[i]=load_bitmap(active_obj[id][i],obj_cache[use].pal);
//      obj_cache[use].sprite=create_bitmap_ex(COLORDEPTH,w=obj_cache[use].sprites[0]->w,h=obj_cache[use].sprites[0]->h);
      }
   else {
        obj_cache[use].frames=1;
        obj_cache[use].mask=load_bitmap(obj_mask[id],obj_cache[use].pal);
        obj_cache[use].sprite=load_bitmap(obj[id],obj_cache[use].pal);
        }
    set_color_depth(COLORDEPTH);
   }
 else {
/* 岻 Cache (ûʹõĿռ䱻ʹ */
   if (obj_cache[use].id!=id) {
      if (obj_cache[use].id>=ACTOBJ) {
         destroy_bitmap(obj_cache[use].mask);
         for (i=0;i<obj_cache[use].frames;i++)
             destroy_bitmap(obj_cache[use].sprites[i]);
         }
      else destroy_bitmap(obj_cache[use].sprite);
      set_color_depth(8);
      obj_cache[use].id=id;
      if (id>=ACTOBJ) {
         id-=ACTOBJ;
         obj_cache[use].frames=active_obj_frames[id];
         obj_cache[use].mask=load_bitmap(active_obj_mask[id],obj_cache[use].pal);
         for (i=0;i<active_obj_frames[id];i++)
             obj_cache[use].sprites[i]=load_bitmap(active_obj[id][i],obj_cache[use].pal);
         }
      else {
           obj_cache[use].frames=1;
           obj_cache[use].mask=load_bitmap(obj_mask[id],obj_cache[use].pal);
           obj_cache[use].sprite=load_bitmap(obj[id],obj_cache[use].pal);
           }
     set_color_depth(COLORDEPTH);
   }
/* ʹƵʵ */
   if (obj_cache[use].freq!=freq-1) {
      if (obj_cache[use].freq==0) {
         for (i=0;i<OBJCACHESIZE;i++)
             if (obj_cache[i].freq<0) obj_cache[i].freq--;
         obj_cache[use].freq=freq-1;
         }
      else obj_cache[use].freq=freq++;
      }
   }
 return use;
}

/* , Cache  9 ϵ尴ǰ,
   ɾظ, ĴֵļֱӸ,ȼ
*/
void obj_buf_sort(int line1,int line2,int line3)
{
 int i,j,k,n,s=0,b=0,e=-1,m,timer=0;
 for (i=0;obj_buf[i].sprite;i++)
    if (obj_buf[i].frames!=1) {
      destroy_bitmap(obj_buf[i].sprite);
      }
 for (i=line1;i<line3+3;i++) {
    if (i==line1+3) i=line2;
    else if (i==line2+3) i=line3;
      for (j=0;j<object_num[i];j++) {
       int cache_id;
       b=0,e=s-1;
/* 2 ֲ, ӽ */
     while (b<=e) {
           m=(b+e)/2;
           if (object[i][j].pos==obj_buf[m].pos) goto loop;
           if (object[i][j].pos<obj_buf[m].pos) e=m-1;
           else b=m+1;
             }
/*  */

     for (k=s;k>b;k--)
        memcpy(&obj_buf[k],&obj_buf[k-1],sizeof(obj_buf[k-1]));
     obj_buf[b].x=object[i][j].x,obj_buf[b].y=object[i][j].y;
     obj_buf[b].pos=object[i][j].pos;
     obj_buf[b].alpha=object[i][j].alpha;
     cache_id=obj_cache_load(object[i][j].id);
     obj_buf[b].onactland=object[i][j].onactland;
     if (object[i][j].id>=ACTOBJ) {
        int w=obj_cache[cache_id].sprites[0]->w,h=obj_cache[cache_id].sprites[0]->h;
       obj_buf[b].frames=object[i][j].frames;
       obj_buf[b].frame=0;
       obj_buf[b].sprite=create_bitmap_ex(COLORDEPTH,w,h);
       obj_buf[b].sprites=obj_cache[cache_id].sprites;
       active_obj_count[timer]=0,active_obj_speed[timer]=object[i][j].speed;
       obj_buf[b].timer_id=timer++;
           }
     else {
       obj_buf[b].sprite=obj_cache[cache_id].sprite;
       obj_buf[b].frames=1;
       }
     obj_buf[b].mask=obj_cache[cache_id].mask;
     obj_buf[b].pal=obj_cache[cache_id].pal;
     ++s;
loop:}
   }
   obj_buf[s].sprite=NULL;
   if (timer<MAXACTOBJ) active_obj_speed[timer]=0;
   buf_obj_num=s;
   /*
   set_gfx_mode(GFX_TEXT,0,0,0,0);
   for (i=0;i<8;i++)
      printf("%d,%d,%d,%d,%d\n",obj_buf[i].pal,obj_buf[i].sprite,obj_buf[i].mask,obj_buf[i].sprites,obj_buf[i].frames);
   exit(0);
   */
}

/* һǰе */
__inline__ void draw_object(int i)
{
   if (obj_buf[i].frames==1) {
      set_palette(obj_buf[i].pal);
      if (obj_buf[i].alpha!=0xff) {
         set_trans_blender(0,0,0,obj_buf[i].alpha);
         draw_trans_sprite(buf,obj_buf[i].sprite,-cache_x+obj_buf[i].x+BLOCKW,-cache_y+obj_buf[i].y+BLOCKH);
         }
      else draw_sprite(buf,obj_buf[i].sprite,-cache_x+obj_buf[i].x+BLOCKW,-cache_y+obj_buf[i].y+BLOCKH);
     }
}
/* ̬,̬ڵر,Ҫ */


void draw_active_object(int i)
{
 BITMAP *actobj_buf=obj_buf[i].sprite;
 int j,timer_id=obj_buf[i].timer_id;
 int x,y,jumpframes;
 LOCK_FUNCTION(active_obj_timer);
 if (obj_buf[i].frames==1) return;
 x=cache_x-obj_buf[i].x-BLOCKW,y=cache_y-obj_buf[i].y-BLOCKH;
 if ((jumpframes=active_obj_count[timer_id]/32)>0) {
   if ((obj_buf[i].frame+=jumpframes)>=obj_buf[i].frames)
     obj_buf[i].frame%=obj_buf[i].frames;
   active_obj_count[timer_id]%=32;
   }
// if (active_obj_count[timer_id]>20) {
//    if (++obj_buf[i].frame>=obj_buf[i].frames) obj_buf[i].frame=0;
//    active_obj_count[timer_id]-=20;
//    }
 else if (active_obj_flush==0 || obj_buf[i].onactland==0) return;
 blit(buf,act_buf,-x,-y,-x,-y,actobj_buf->w,actobj_buf->h);
 set_clip(act_buf,MAX(-x,0),MAX(-y,0),MIN(-x+actobj_buf->w,SCREENW+BLOCKW)-1,MIN(-y+actobj_buf->h,SCREENH+BLOCKH)-1);
 for (j=0;j<i;j++) {
   set_palette(obj_buf[j].pal);
   if (obj_buf[j].frames==1) {
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(act_buf,obj_buf[j].sprite,-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
     }
   else draw_sprite(act_buf,obj_buf[j].sprite,-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
    }
   else {
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(act_buf,obj_buf[j].sprites[obj_buf[j].frame],-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
     }
   else draw_sprite(act_buf,obj_buf[j].sprites[obj_buf[j].frame],-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
    }
   }
 for (j=i+1;j<OBJCACHESIZE && obj_buf[j].sprite!=NULL;j++)
   if (obj_buf[j].frames>1) {
   set_palette(obj_buf[j].pal);
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(act_buf,obj_buf[j].sprites[obj_buf[j].frame],-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
     }
   else draw_sprite(act_buf,obj_buf[j].sprites[obj_buf[j].frame],-cache_x+obj_buf[j].x+BLOCKW,-cache_y+obj_buf[j].y+BLOCKH);
    }
 set_clip(act_buf,0,0,SCREENW+BLOCKW-1,SCREENH+BLOCKH-1);

 clear_to_color(actobj_buf,MASK_COLOR);
 set_palette(obj_buf[i].pal);
 draw_sprite(actobj_buf,obj_buf[i].sprites[obj_buf[i].frame],0,0);
 if (obj_buf[i].alpha!=0xff) {
    set_trans_blender(0,0,0,255-obj_buf[i].alpha);
    draw_trans_sprite(actobj_buf,act_buf,x,y);
    }
 for (j=i+1;j<OBJCACHESIZE && obj_buf[j].sprite!=NULL;j++) {
   set_palette(obj_buf[j].pal);
   if (obj_buf[j].frames==1) {
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(actobj_buf,obj_buf[j].sprite,obj_buf[j].x-obj_buf[i].x,obj_buf[j].y-obj_buf[i].y);
     }
   else draw_sprite(actobj_buf,obj_buf[j].sprite,obj_buf[j].x-obj_buf[i].x,obj_buf[j].y-obj_buf[i].y);
    }
   else if (obj_buf[j].y<obj_buf[i].y+actobj_buf->h && obj_buf[j].x<obj_buf[i].x+actobj_buf->w) {
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(actobj_buf,obj_buf[j].sprites[obj_buf[j].frame],obj_buf[j].x-obj_buf[i].x,obj_buf[j].y-obj_buf[i].y);
     }
   else draw_sprite(actobj_buf,obj_buf[j].sprites[obj_buf[j].frame],obj_buf[j].x-obj_buf[i].x,obj_buf[j].y-obj_buf[i].y);
    }
   }
   draw_sprite(act_buf,actobj_buf,-cache_x+obj_buf[i].x+BLOCKW,-cache_y+obj_buf[i].y+BLOCKH);

// blit(act_buf,screen,screen_x-cache_x,screen_y-cache_y,0,0,SCREENW,SCREENH);
// readkey();

}


