#include <allegro.h>
#include <stdlib.h>
#define MAXFLAKES 200
#define GRAVITY ftofix(-4.7)
#define YWIND ftofix(0.7)
#define ZDIST itofix(100)
#define XWIDTH itofix(512)
#define YHEIGHT itofix(300)
#define ZDEPTH itofix(500)
#define ONE itofix(1)
#define SCREENW 320
#define SCREENH 240

extern BITMAP *screenbuf[2];
extern int screen_id;

typedef struct {
  fixed x,y,z;
  fixed dx,dy,dz;
  } PARTICLE;

PARTICLE snowflakes[MAXFLAKES];
unsigned char time=0;
int snowcolor[256];

void wu_pixel(fixed wx, fixed wy ,unsigned char wb)
{
 int x,y;
 x=fixtoi(wx)*2,y=fixtoi(wy)*2;
 rectfill(screenbuf[screen_id],x,y,x+3,y+3,0xffff);
}

void show_particles()
{
 unsigned i,tmp;
 int x,y;
 unsigned char c;
// sync();
// blit(bmp,screen,0,0,0,0,SCREENW,SCREENH);
// clear(bmp);
 for (i=0;i<MAXFLAKES;i++)
     if (snowflakes[i].z > itofix(SCREENH/2)) {
        x = itofix(SCREENW/2-1) + 256*fdiv(snowflakes[i].x,snowflakes[i].z);
        y = itofix(SCREENH/2-1) - 256*fdiv(snowflakes[i].y,snowflakes[i].z);
        tmp = fixtoi(itofix(256)-((snowflakes[i].z - ZDIST)>>1));
        if ((x>itofix(0)) && (x<itofix(SCREENW-1)) && (y>itofix(0)) && (y<itofix(SCREENH-1))) {
           if (tmp > 255) c = 255;
           else c = tmp & 0xff;
           wu_pixel(x,y,c);
           }
        }
}

void update_particles()
{
 int i;
 for (i=0;i<MAXFLAKES;i++) {
     snowflakes[i].x += snowflakes[i].dx;
     if (snowflakes[i].x < -XWIDTH/2) snowflakes[i].x = XWIDTH/2;
     if (snowflakes[i].x > XWIDTH/2) snowflakes[i].x = -XWIDTH/2;
     snowflakes[i].y += snowflakes[i].dy;
     if (snowflakes[i].y < -YHEIGHT/2) {
         snowflakes[i].x = fmul((random()&0xffff) , XWIDTH) - XWIDTH/2;
         snowflakes[i].y = YHEIGHT/2;
         snowflakes[i].z = fmul((random()&0xffff) , ZDEPTH) + ZDIST;
         }
     snowflakes[i].z += snowflakes[i].dz;
   }
}

void update_velocities()
{
 int i;
 unsigned char x1,y1,z1;
 for (i=0;i<MAXFLAKES;i++) {
     x1=fixtoi(snowflakes[i].x);
     y1=fixtoi(snowflakes[i].y);
     z1=fixtoi(snowflakes[i].z);
     snowflakes[i].dx=fdiv((fsin(itofix(z1+time>>2))+fcos(itofix(y1-time))),ftofix(1.7));
     snowflakes[i].dy=fmul(fdiv((snowflakes[i].dy+GRAVITY+fsin(itofix(z1+x1+time))),ftofix(2.8)),YWIND);
     snowflakes[i].dz=fdiv((fcos(itofix(x1-time<<1))+fsin(itofix(y1+time))),itofix(11));
     }
}

void snow_init()
{
 int i;
 for (i=0;i<MAXFLAKES;i++) {
  snowflakes[i].x = fmul((random()&0xffff),XWIDTH) - XWIDTH/2;
  snowflakes[i].y = fmul((random()&0xffff),YHEIGHT) - YHEIGHT/2;
  snowflakes[i].z = fmul((random()&0xffff),ZDEPTH) + ZDIST;
  snowflakes[i].dx = snowflakes[i].dy = snowflakes[i].dz = itofix(0);
  }
 for (i=0;i<256;i++) {
    int b=i;
    snowcolor[255-i]=makecol(i,i,i);
    }
}

int show_snow()
{
 update_particles();
 update_velocities();
 show_particles();
 ++time;
}

