#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "leanview.h"


int sprite_num;
int ani_num[MAXSPRITES];
int frames[MAXSPRITES][ANIMAX];
char sprite[MAXSPRITES][DIS][ANIMAX][MAXFRAMES][40];
char sprite_mask[MAXSPRITES][DIS][ANIMAX][40];

SPRITE_BUF sprite_buf[SPRITEBUFSIZE];
SPRITE_CACHE sprite_cache[SPRITECACHESIZE];

int sprite_cache_load(int id);

volatile short sprite_count[SPRITEBUFSIZE];
short sprite_speed[SPRITEBUFSIZE];

char sprite_relation[SPRITEBUFSIZE][SPRITEBUFSIZE];
char sprite_s[SPRITEBUFSIZE][SPRITEBUFSIZE];
char sprite_nomoved[SPRITEBUFSIZE];
short sprite_order[SPRITEBUFSIZE];
BITMAP *trans_sprite_buf;
BITMAP *draw_sprite_buf;

extern int cache_x,screen_x;
extern int cache_y,screen_y;
extern short active_obj_flush;
extern BITMAP *buf,*act_buf;
extern BITMAP *screenbuf[2];
extern int screen_id;
extern short buf_obj_num;
extern OBJ_BUF obj_buf[OBJCACHESIZE];

typedef struct {
        int x;
        int y;
        int w;
        int h;
        BITMAP *mask;
        } MASK_OBJ;

int back(MASK_OBJ *a,MASK_OBJ *b)
{
 int swap=0,back,i,a1,b1,w;
 MASK_OBJ *t;
 if (a->x > b->x) t=a,a=b,b=t,swap=1;
 if (b->x >= a->x+a->w) return 0;
 if (b->y+b->h-b->mask->h >= a->y+a->h) back=1;
 else if (a->y+a->h-a->mask->h >= b->y+b->h) back=-1;
 else {
   w=(a->x+a->mask->w-b->x)/2;
   for (i=0;i<a->mask->h;i++)
      if (_getpixel(a->mask,b->x-a->x+w,i)==0) break;
   a1=a->y+a->h-a->mask->h+i;
   for (i=0;i<b->mask->h;i++)
      if (_getpixel(b->mask,w,i)==0) break;
   b1=b->y+b->h-b->mask->h+i;
   if (a1<b1) back=1;
   else back=-1;
     }
 if (swap) back=-back;
 return back;
}

void sprite_sort()
{
 int i,j;
 MASK_OBJ a,b;
 for (i=0;i<SPRITEBUFSIZE-1 && sprite_buf[i].images;i++) {
//    if (sprite_nomoved[i]) continue;
    a.x=sprite_buf[i].pathx[sprite_buf[i].step],a.y=sprite_buf[i].pathy[sprite_buf[i].step];
    a.w=sprite_buf[i].buf->w,a.h=sprite_buf[i].buf->h;
    a.mask=sprite_buf[i].images->mask[sprite_buf[i].dis[sprite_buf[i].step]][sprite_buf[i].stat];
    for (j=i+1;j<SPRITEBUFSIZE-1 && sprite_buf[j].images;j++) {
       b.x=sprite_buf[j].pathx[sprite_buf[j].step],b.y=sprite_buf[j].pathy[sprite_buf[j].step];
       b.w=sprite_buf[j].buf->w,b.h=sprite_buf[j].buf->h;
       b.mask=sprite_buf[j].images->mask[sprite_buf[j].dis[sprite_buf[j].step]][sprite_buf[j].stat];
       sprite_relation[j][i]=-(sprite_relation[i][j]=back(&a,&b));
       }
    }
}

void sprite_timer()
{
 int i;
 for (i=0;sprite_speed[i] && i<SPRITEBUFSIZE;i++)
    sprite_count[i]+=sprite_speed[i];
}

END_OF_FUNCTION(sprite_timer);

void sprite_init()
{
 int i,j,k,l;
 FILE *f;
 char path[20];

 f=fopen("sprite.dat","r");
 fscanf(f,"%d\n",&sprite_num);
 fgets(path,20,f);
 for (i=0;i<sprite_num;i++) {
    fscanf(f,"%d\n",&ani_num[i]);
    for (j=0;j<ani_num[i];j++)
       fscanf(f,"%d\n",&frames[i][j]);
    for (j=0;j<DIS;j++)
       for (k=0;k<ani_num[i];k++) {
          for (l=0;l<frames[i][k];l++) {
             strcpy(sprite[i][j][k][l],path);
             fgets(strchr(sprite[i][j][k][l],'\n'),40,f);
             *strchr(sprite[i][j][k][l],'\n')=0;
             }
          strcpy(sprite_mask[i][j][k],path);
          fgets(strchr(sprite_mask[i][j][k],'\n'),40,f);
          *strchr(sprite_mask[i][j][k],'\n')=0;
          }
    }
 fclose(f);
 for (i=0;i<SPRITECACHESIZE;i++)
    sprite_cache[i].id=sprite_cache[i].freq=-1;
 for (i=0;i<SPRITEBUFSIZE;i++)
    sprite_buf[i].images=NULL,
    sprite_speed[i]=0;
 bzero(sprite_relation,SPRITEBUFSIZE*SPRITEBUFSIZE);
 bzero(sprite_nomoved,SPRITEBUFSIZE);
 trans_sprite_buf=create_bitmap_ex(COLORDEPTH,SPRITEMAXSIZE,SPRITEMAXSIZE);
 draw_sprite_buf=create_bitmap_ex(COLORDEPTH,SPRITEMAXSIZE,SPRITEMAXSIZE);
 clear_to_color(draw_sprite_buf,MASK_COLOR);
 LOCK_DATA((void *)sprite_count,i*sizeof(sprite_count[0]));
 LOCK_DATA((void *)sprite_speed,i*sizeof(sprite_speed[0]));
 LOCK_VARIABLE(sprite_count);
 LOCK_FUNCTION(sprite_timer);
 install_int_ex(sprite_timer,  BPS_TO_TIMER(40));
}

int sprite_cache_load(int id)
{
 static int freq=0;
 int i,j,k,use,minfreq=MAXINT;
 for (i=0;i<SPRITECACHESIZE;i++) {
    if (sprite_cache[i].id==id) {
      use=i;
      break;
      }
    if (sprite_cache[i].freq<minfreq) minfreq=sprite_cache[i].freq,use=i;
    }
 if (sprite_cache[use].id==-1) {
   sprite_cache[use].id=id;
   sprite_cache[use].freq=freq++;
   sprite_cache[use].ani=ani_num[id];
   for (j=0;j<ani_num[id];j++)
      sprite_cache[use].frames[j]=frames[id][j];
   set_color_depth(8);
   for (i=0;i<DIS;i++)
      for (j=0;j<ani_num[id];j++) {
         sprite_cache[use].mask[i][j]=load_bitmap(sprite_mask[id][i][j],sprite_cache[use].pal);
         for (k=0;k<sprite_cache[use].frames[j];k++) {
            char *c=sprite[id][i][j][k];
            sprite_cache[use].sprites[i][j][k]=load_bitmap(sprite[id][i][j][k],sprite_cache[use].pal);
            c=sprite[id][i][j][k];
            }
         }
   set_color_depth(COLORDEPTH);
   }
 else {
   if (sprite_cache[use].id!=id) {
      for (i=0;i<DIS;i++)
          for (j=0;j<sprite_cache[use].ani;j++) {
              destroy_bitmap(sprite_cache[use].mask[i][j]);
              for (k=0;k<sprite_cache[use].frames[j];k++)
                 destroy_bitmap(sprite_cache[use].sprites[i][j][k]);
     sprite_cache[use].id=id;
     sprite_cache[use].ani=ani_num[id];
     for (j=0;j<ani_num[id];j++)
        sprite_cache[use].frames[j]=frames[id][j];
     set_color_depth(8);
     for (i=0;i<DIS;i++)
        for (j=0;j<ani_num[id];j++) {
           sprite_cache[use].mask[i][j]=load_bitmap(sprite_mask[id][i][j],sprite_cache[use].pal);
           for (k=0;k<frames[id][j];k++)
              sprite_cache[use].sprites[i][j][k]=load_bitmap(sprite[id][i][j][k],sprite_cache[use].pal);
         }
     set_color_depth(COLORDEPTH);
   }
   if (sprite_cache[use].freq!=freq-1) {
      if (sprite_cache[use].freq==0) {
         for (i=0;i<OBJCACHESIZE;i++)
             if (sprite_cache[i].freq<0) sprite_cache[i].freq--;
         sprite_cache[use].freq=freq-1;
         }
      else sprite_cache[use].freq=freq++;
      }
   }
 }
 return use;
}

int sprite_load(int id,int x,int y,int alpha,int dis,int speed)
{
 int i;
 for (i=0;i<SPRITEBUFSIZE && sprite_speed[i]!=0;i++);
 sprite_speed[i]=speed;
 sprite_count[i]=0;
 for (i=0;i<SPRITEBUFSIZE && sprite_buf[i].images;i++) ;
 sprite_buf[i].pathx[0]=x,sprite_buf[i].pathy[0]=y;
 sprite_buf[i].alpha=alpha;
 sprite_buf[i].dis[0]=dis,sprite_buf[i].stat=STAND,sprite_buf[i].frame=0;
 sprite_buf[i].pathlen=0,sprite_buf[i].step=0;
 sprite_buf[i].images=&sprite_cache[sprite_cache_load(id)];
 sprite_buf[i].buf=create_sub_bitmap(draw_sprite_buf,0,0,sprite_buf[i].images->sprites[0][0][0]->w,sprite_buf[i].images->sprites[0][0][0]->h);
// sprite_buf[i].buf=create_bitmap(sprite_buf[i].images->sprites[0][0][0]->w,sprite_buf[i].images->sprites[0][0][0]->h);
 return i;
}

void sprite_unload(int id)
{
 int i;
 destroy_bitmap(sprite_buf[id].buf);
 for (i=id+1;i<SPRITEBUFSIZE && sprite_buf[i].images;i++)
    memcpy(&sprite_buf[i-1],&sprite_buf[i],sizeof(sprite_buf[i]));
 sprite_buf[i].images=NULL;
}

void draw_sp(int i)
{
 int j,x,y,step=sprite_buf[i].step,dis,jumpframes,pathlen;
 BITMAP *spritebuf=sprite_buf[i].buf;
 LOCK_FUNCTION(sprite_timer);
 x=sprite_buf[i].pathx[step],y=sprite_buf[i].pathy[step],dis=sprite_buf[i].dis[step];
 jumpframes=sprite_count[i]/32;
 if ((sprite_buf[i].frame+=jumpframes)>=sprite_buf[i].images->frames[sprite_buf[i].stat])
   sprite_buf[i].frame%=sprite_buf[i].images->frames[sprite_buf[i].stat];
 sprite_count[i]%=32;
 if (x-screen_x+BLOCKW>=SCREENW ||
     y-screen_y+BLOCKH>=SCREENH ||
     x-screen_x+BLOCKW<=-spritebuf->w ||
     y-screen_y+BLOCKH<=-spritebuf->h) return;

 clear_to_color(spritebuf,MASK_COLOR);
 set_palette(sprite_buf[i].images->pal);
 draw_sprite(spritebuf,sprite_buf[i].images->sprites[dis][sprite_buf[i].stat][sprite_buf[i].frame],0,0);

 if (sprite_buf[i].alpha !=255) {
      blit(screenbuf[screen_id],trans_sprite_buf,-screen_x+x+BLOCKW,-screen_y+y+BLOCKH,0,0,spritebuf->w,spritebuf->h);
      set_trans_blender(0,0,0,255-sprite_buf[i].alpha);
      draw_trans_sprite(spritebuf,trans_sprite_buf,0,0);
      }

 for (j=sprite_order[i];j<buf_obj_num;j++) {
   set_palette(obj_buf[j].pal);
   if (obj_buf[j].frames==1) {
   if (obj_buf[j].alpha!=0xff) set_trans_blender(0,0,0,obj_buf[j].alpha);
   else set_trans_blender(0,0,0,BACKALPHA);
     draw_trans_sprite(spritebuf,obj_buf[j].sprite,obj_buf[j].x-x,obj_buf[j].y-y);
    }
   else  if (obj_buf[j].y<y+spritebuf->h && obj_buf[j].x<x+spritebuf->w) {
   if (obj_buf[j].alpha!=0xff) {
     set_trans_blender(0,0,0,obj_buf[j].alpha);
     draw_trans_sprite(spritebuf,obj_buf[j].sprites[obj_buf[j].frame],obj_buf[j].x-x,obj_buf[j].y-y);
     }
   else  draw_sprite(spritebuf,obj_buf[j].sprites[obj_buf[j].frame],obj_buf[j].x-x,obj_buf[j].y-y);
    }
   }
   masked_blit(spritebuf,screenbuf[screen_id],0,0,-screen_x+x+BLOCKW,-screen_y+y+BLOCKH,spritebuf->w,spritebuf->h);
//   draw_sprite(screenbuf[screen_id],spritebuf,-screen_x+x+BLOCKW,-screen_y+y+BLOCKH);

   if ((sprite_buf[i].step+=jumpframes)>(pathlen=sprite_buf[i].pathlen))
     sprite_buf[i].stat=STAND,sprite_buf[i].pathx[0]=sprite_buf[i].pathx[pathlen],
     sprite_buf[i].pathy[0]=sprite_buf[i].pathy[pathlen],
     sprite_buf[i].dis[0]=sprite_buf[i].dis[pathlen],
     sprite_buf[i].pathlen=sprite_buf[i].step=0;
   if (sprite_buf[i].stat!=STAND) sprite_nomoved[i]=0;
}

void draw_sprites()
{
 int i,j,m,p,s;
 char drawn[SPRITEBUFSIZE];
 sprite_sort();
 bzero(drawn,SPRITEBUFSIZE);
 memcpy(sprite_s,sprite_relation,SPRITEBUFSIZE*SPRITEBUFSIZE);
 for (s=m=0;m<SPRITEBUFSIZE && sprite_buf[m].images;m++) {
     int begin=s;
     for (i=0;i<SPRITEBUFSIZE && sprite_buf[i].images;i++) {
        if (drawn[i]) continue;
         for (p=j=0;j<SPRITEBUFSIZE && sprite_buf[j].images;j++)
             if (sprite_s[i][j]<0) { p=1;break;}
         if (p==0) {
           if (!sprite_nomoved[i]) {
             MASK_OBJ a,b;
             int sb=begin,se=buf_obj_num-1,m;
             a.x=sprite_buf[i].pathx[sprite_buf[i].step],a.y=sprite_buf[i].pathy[sprite_buf[i].step];
             a.w=sprite_buf[i].buf->w,a.h=sprite_buf[i].buf->h;
             a.mask=sprite_buf[i].images->mask[sprite_buf[i].dis[sprite_buf[i].step]][sprite_buf[i].stat];
             while (sb<=se) {
               m=(sb+se)/2;
               b.x=obj_buf[m].x,b.y=obj_buf[m].y;
               b.w=obj_buf[m].sprite->w,b.h=obj_buf[m].sprite->h;
               b.mask=obj_buf[m].mask;
               if (back(&a,&b)==1) se=m-1;
               else sb=m+1;
               }
             sprite_order[i]=sb;
             }
            if (sprite_order[i]>s) s=sprite_order[i];
            draw_sp(i);
//            sprite_nomoved[i]=1;
            drawn[i]=1;
            for (j=0;j<SPRITEBUFSIZE && sprite_buf[j].images;j++)
            sprite_s[i][j]=sprite_s[j][i]=0;
            }
         }
        }
 }


int skipstep;

void walkfunc(BITMAP *bmp,int x,int y,int id)
{
 if (skipstep%STEPLEN==0) {
   sprite_buf[id].pathx[skipstep/STEPLEN]=x,sprite_buf[id].pathy[skipstep/STEPLEN]=y;
   }
 skipstep++;
}

void walkto(int id,int x,int y)
{
 int cx,cy,step=sprite_buf[id].step,i,dis,sx,sy;
 cx=sprite_buf[id].pathx[step],cy=sprite_buf[id].pathy[step];
 skipstep=0;
 sx=x-cx,sy=y-cy;
 if (sx>=0) {
   if (sy>=0) {
      if (sx*100<sy*31) dis=0;
      else if (sx*100<sy*181) dis=1;
      else dis=2;
      }
   else {
     if (sx*100<-sy*31) dis=4;
     else if (sx*100<-sy*181) dis=3;
     else dis=2;
     }
   }
 else {
   if (sy>=0) {
      if (-sx*100<sy*31) dis=0;
      else if (-sx*100<sy*181) dis=7;
      else dis=6;
      }
   else {
     if (-sx*100<-sy*31) dis=4;
     else if (-sx*100<-sy*181) dis=5;
     else dis=6;
     }
   }
 do_line(NULL,cx,cy,x,y,id,walkfunc);
 sprite_buf[id].step=0,sprite_buf[id].pathlen=skipstep/STEPLEN-1;
 sprite_buf[id].stat=WALK;
 for (i=0;i<=sprite_buf[id].pathlen;i++)
   sprite_buf[id].dis[i]=dis;
}







